#include <bits/stdc++.h>

using namespace std;

#define pb push_back
#define x first
#define y second
#define IOS ios :: sync_with_stdio(0); cin.tie(0); cout.tie(0);
#define endl "\n"
typedef long long ll;
typedef pair<int, int> pi;
typedef pair<ll, ll> pll;

const int N = 3e5 + 5;
int n, vis[N], first[N], seg[8 * N + 1], pref[3][N];
vector<pi> edge[N];
vector<int> euler;

void dfs(int u, int height) {
    vis[u] = height;
    first[u] = euler.size();
    euler.pb(u);
    for (auto v : edge[u]) {
        if (!vis[v.x]) {
            for (int i = 0; i < 3; i++) pref[i][v.x] = pref[i][u];
            pref[v.y][v.x]++;
            dfs(v.x, height + 1);
            euler.pb(u);
        }
    }
}

void build(int node, int ls, int rs) {
    if (ls == rs) seg[node] = euler[ls]; else {
        int ms = (ls + rs) / 2;
        build(2 * node, ls, ms);
        build(2 * node + 1, ms + 1, rs);
        int a = seg[2 * node], b = seg[2 * node + 1];
        seg[node] = vis[a] < vis[b] ? a : b;
    }
}

int get(int node, int ls, int rs, int left, int right) {
    if (left <= ls && rs <= right) return seg[node]; else
    if (rs < left || right < ls) return -1; else {
        int ms = (ls + rs) / 2;
        int a = get(2 * node, ls, ms, left, right), b = get(2 * node + 1, ms + 1, rs, left, right);
        if (a == -1) return b; else
        if (b == -1) return a; else
            return vis[a] < vis[b] ? a : b;
    }
}

int lca(int u, int v) {
    int a = first[u], b = first[v];
    if (a > b) swap(a, b);
    return get(1, 0, euler.size() - 1, a, b);
}

int main()
{
    IOS;
    cin >> n;
    for (int i = 1; i < n; i++) {
        int u, v;
        string c;
        cin >> u >> v >> c;
        int w;
        --u, --v;
        if (c == "S") w = 0; else
        if (c == "I") w = 1; else
            w = 2;
        edge[u].pb({v, w});
        edge[v].pb({u, w});
    }
    dfs(0, 1);
    if (n <= 1000) {
        build(1, 0, euler.size() - 1);
        int ans = 0;
        for (int i = 0; i < n; i++) {
            for (int j = i + 1; j < n; j++) {
                int tmp = lca(i, j);
                int a = pref[0][i] + pref[0][j] - 2 * pref[0][tmp];
                int b = pref[1][i] + pref[1][j] - 2 * pref[1][tmp];
                int c = pref[2][i] + pref[2][j] - 2 * pref[2][tmp];
                if (a == b && b == c) {
                    ans++;
                }
            }
        }
        cout << ans;
    } else {
        map<pair<int, pair<int, int> >, ll> m;
        for (int i = 0; i < n; i++) {
            int mn = INT_MAX;
            for (int j = 0; j < 3; j++) mn = min(mn, pref[j][i]);
            for (int j = 0; j < 3; j++) pref[j][i] -= mn;
            m.insert({{pref[0][i], {pref[1][i], pref[2][i]}}, 0});
            m[{pref[0][i], {pref[1][i], pref[2][i]}}]++;
        }
        ll ans = 0;
        for (auto it : m) {
            ans += it.y * (it.y - 1) / 2;
        }
        cout << ans;
    }
    return 0;
}